@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.inputs.GroupProtectedEnvironmentDeployAccessLevelArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessLevel Levels of access required to deploy to this protected environment. Mutually exclusive with `user_id` and `group_id`. Valid values are `developer`, `maintainer`.
 * @property accessLevelDescription Readable description of level of access.
 * @property groupId The ID of the group allowed to deploy to this protected environment. The group must be a sub-group under the given group. Mutually exclusive with `access_level` and `user_id`.
 * @property groupInheritanceType Group inheritance allows deploy access levels to take inherited group membership into account. Valid values are `0`, `1`. `0` => Direct group membership only, `1` => All inherited groups. Default: `0`
 * @property id The unique ID of the Deploy Access Level object.
 * @property userId The ID of the user allowed to deploy to this protected environment. The user must be a member of the group with Maintainer role or higher. Mutually exclusive with `access_level` and `group_id`.
 */
public data class GroupProtectedEnvironmentDeployAccessLevelArgs(
    public val accessLevel: Output<String>? = null,
    public val accessLevelDescription: Output<String>? = null,
    public val groupId: Output<Int>? = null,
    public val groupInheritanceType: Output<Int>? = null,
    public val id: Output<Int>? = null,
    public val userId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GroupProtectedEnvironmentDeployAccessLevelArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GroupProtectedEnvironmentDeployAccessLevelArgs =
        com.pulumi.gitlab.inputs.GroupProtectedEnvironmentDeployAccessLevelArgs.builder()
            .accessLevel(accessLevel?.applyValue({ args0 -> args0 }))
            .accessLevelDescription(accessLevelDescription?.applyValue({ args0 -> args0 }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .groupInheritanceType(groupInheritanceType?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .userId(userId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupProtectedEnvironmentDeployAccessLevelArgs].
 */
@PulumiTagMarker
public class GroupProtectedEnvironmentDeployAccessLevelArgsBuilder internal constructor() {
    private var accessLevel: Output<String>? = null

    private var accessLevelDescription: Output<String>? = null

    private var groupId: Output<Int>? = null

    private var groupInheritanceType: Output<Int>? = null

    private var id: Output<Int>? = null

    private var userId: Output<Int>? = null

    /**
     * @param value Levels of access required to deploy to this protected environment. Mutually exclusive with `user_id` and `group_id`. Valid values are `developer`, `maintainer`.
     */
    @JvmName("jsjaohxstlbevwhi")
    public suspend fun accessLevel(`value`: Output<String>) {
        this.accessLevel = value
    }

    /**
     * @param value Readable description of level of access.
     */
    @JvmName("jwfkjhrhtlibyjfy")
    public suspend fun accessLevelDescription(`value`: Output<String>) {
        this.accessLevelDescription = value
    }

    /**
     * @param value The ID of the group allowed to deploy to this protected environment. The group must be a sub-group under the given group. Mutually exclusive with `access_level` and `user_id`.
     */
    @JvmName("jlngnjupdlpinsyc")
    public suspend fun groupId(`value`: Output<Int>) {
        this.groupId = value
    }

    /**
     * @param value Group inheritance allows deploy access levels to take inherited group membership into account. Valid values are `0`, `1`. `0` => Direct group membership only, `1` => All inherited groups. Default: `0`
     */
    @JvmName("asbcbckdfekuykyu")
    public suspend fun groupInheritanceType(`value`: Output<Int>) {
        this.groupInheritanceType = value
    }

    /**
     * @param value The unique ID of the Deploy Access Level object.
     */
    @JvmName("joivcmefwhdfkdyo")
    public suspend fun id(`value`: Output<Int>) {
        this.id = value
    }

    /**
     * @param value The ID of the user allowed to deploy to this protected environment. The user must be a member of the group with Maintainer role or higher. Mutually exclusive with `access_level` and `group_id`.
     */
    @JvmName("ruxcpuunfnkgkjof")
    public suspend fun userId(`value`: Output<Int>) {
        this.userId = value
    }

    /**
     * @param value Levels of access required to deploy to this protected environment. Mutually exclusive with `user_id` and `group_id`. Valid values are `developer`, `maintainer`.
     */
    @JvmName("rrcboejclhhacqyq")
    public suspend fun accessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLevel = mapped
    }

    /**
     * @param value Readable description of level of access.
     */
    @JvmName("fbawbefdfqqssxmy")
    public suspend fun accessLevelDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLevelDescription = mapped
    }

    /**
     * @param value The ID of the group allowed to deploy to this protected environment. The group must be a sub-group under the given group. Mutually exclusive with `access_level` and `user_id`.
     */
    @JvmName("dfglvivkridluscb")
    public suspend fun groupId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value Group inheritance allows deploy access levels to take inherited group membership into account. Valid values are `0`, `1`. `0` => Direct group membership only, `1` => All inherited groups. Default: `0`
     */
    @JvmName("ngenbitootrvyurb")
    public suspend fun groupInheritanceType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupInheritanceType = mapped
    }

    /**
     * @param value The unique ID of the Deploy Access Level object.
     */
    @JvmName("hhanvyhpgvfqpjkx")
    public suspend fun id(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The ID of the user allowed to deploy to this protected environment. The user must be a member of the group with Maintainer role or higher. Mutually exclusive with `access_level` and `group_id`.
     */
    @JvmName("tdiqucuqeangdmha")
    public suspend fun userId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    internal fun build(): GroupProtectedEnvironmentDeployAccessLevelArgs =
        GroupProtectedEnvironmentDeployAccessLevelArgs(
            accessLevel = accessLevel,
            accessLevelDescription = accessLevelDescription,
            groupId = groupId,
            groupInheritanceType = groupInheritanceType,
            id = id,
            userId = userId,
        )
}
