@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.inputs.GroupPushRulesArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authorEmailRegex All commit author emails must match this regex, e.g. `@my-company.com$`.
 * @property branchNameRegex All branch names must match this regex, e.g. `(feature|hotfix)\/*`.
 * @property commitCommitterCheck Only commits pushed using verified emails are allowed.  **Note** This attribute is only supported in GitLab versions >= 16.4.
 * @property commitCommitterNameCheck Users can only push commits to this repository if the commit author name is consistent with their GitLab account name.
 * @property commitMessageNegativeRegex No commit message is allowed to match this regex, for example `ssh\:\/\/`.
 * @property commitMessageRegex All commit messages must match this regex, e.g. `Fixed \d+\..*`.
 * @property denyDeleteTag Deny deleting a tag.
 * @property fileNameRegex Filenames matching the regular expression provided in this attribute are not allowed, for example, `(jar|exe)$`.
 * @property maxFileSize Maximum file size (MB) allowed.
 * @property memberCheck Allows only GitLab users to author commits.
 * @property preventSecrets GitLab will reject any files that are likely to contain secrets.
 * @property rejectNonDcoCommits Reject commit when it’s not DCO certified.
 * @property rejectUnsignedCommits Only commits signed through GPG are allowed.  **Note** This attribute is only supported in GitLab versions >= 16.4.
 * */
 */
public data class GroupPushRulesArgs(
    public val authorEmailRegex: Output<String>? = null,
    public val branchNameRegex: Output<String>? = null,
    public val commitCommitterCheck: Output<Boolean>? = null,
    public val commitCommitterNameCheck: Output<Boolean>? = null,
    public val commitMessageNegativeRegex: Output<String>? = null,
    public val commitMessageRegex: Output<String>? = null,
    public val denyDeleteTag: Output<Boolean>? = null,
    public val fileNameRegex: Output<String>? = null,
    public val maxFileSize: Output<Int>? = null,
    public val memberCheck: Output<Boolean>? = null,
    public val preventSecrets: Output<Boolean>? = null,
    public val rejectNonDcoCommits: Output<Boolean>? = null,
    public val rejectUnsignedCommits: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GroupPushRulesArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GroupPushRulesArgs =
        com.pulumi.gitlab.inputs.GroupPushRulesArgs.builder()
            .authorEmailRegex(authorEmailRegex?.applyValue({ args0 -> args0 }))
            .branchNameRegex(branchNameRegex?.applyValue({ args0 -> args0 }))
            .commitCommitterCheck(commitCommitterCheck?.applyValue({ args0 -> args0 }))
            .commitCommitterNameCheck(commitCommitterNameCheck?.applyValue({ args0 -> args0 }))
            .commitMessageNegativeRegex(commitMessageNegativeRegex?.applyValue({ args0 -> args0 }))
            .commitMessageRegex(commitMessageRegex?.applyValue({ args0 -> args0 }))
            .denyDeleteTag(denyDeleteTag?.applyValue({ args0 -> args0 }))
            .fileNameRegex(fileNameRegex?.applyValue({ args0 -> args0 }))
            .maxFileSize(maxFileSize?.applyValue({ args0 -> args0 }))
            .memberCheck(memberCheck?.applyValue({ args0 -> args0 }))
            .preventSecrets(preventSecrets?.applyValue({ args0 -> args0 }))
            .rejectNonDcoCommits(rejectNonDcoCommits?.applyValue({ args0 -> args0 }))
            .rejectUnsignedCommits(rejectUnsignedCommits?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupPushRulesArgs].
 */
@PulumiTagMarker
public class GroupPushRulesArgsBuilder internal constructor() {
    private var authorEmailRegex: Output<String>? = null

    private var branchNameRegex: Output<String>? = null

    private var commitCommitterCheck: Output<Boolean>? = null

    private var commitCommitterNameCheck: Output<Boolean>? = null

    private var commitMessageNegativeRegex: Output<String>? = null

    private var commitMessageRegex: Output<String>? = null

    private var denyDeleteTag: Output<Boolean>? = null

    private var fileNameRegex: Output<String>? = null

    private var maxFileSize: Output<Int>? = null

    private var memberCheck: Output<Boolean>? = null

    private var preventSecrets: Output<Boolean>? = null

    private var rejectNonDcoCommits: Output<Boolean>? = null

    private var rejectUnsignedCommits: Output<Boolean>? = null

    /**
     * @param value All commit author emails must match this regex, e.g. `@my-company.com$`.
     */
    @JvmName("vjmnyudqxxxkhctx")
    public suspend fun authorEmailRegex(`value`: Output<String>) {
        this.authorEmailRegex = value
    }

    /**
     * @param value All branch names must match this regex, e.g. `(feature|hotfix)\/*`.
     * */
     */
    @JvmName("lelgudcvxqmdxncy")
    public suspend fun branchNameRegex(`value`: Output<String>) {
        this.branchNameRegex = value
    }

    /**
     * @param value Only commits pushed using verified emails are allowed.  **Note** This attribute is only supported in GitLab versions >= 16.4.
     */
    @JvmName("vrlbwrcrmjlurbfq")
    public suspend fun commitCommitterCheck(`value`: Output<Boolean>) {
        this.commitCommitterCheck = value
    }

    /**
     * @param value Users can only push commits to this repository if the commit author name is consistent with their GitLab account name.
     */
    @JvmName("tebuarusqbatmvau")
    public suspend fun commitCommitterNameCheck(`value`: Output<Boolean>) {
        this.commitCommitterNameCheck = value
    }

    /**
     * @param value No commit message is allowed to match this regex, for example `ssh\:\/\/`.
     */
    @JvmName("jeswrssfvqjpuxdl")
    public suspend fun commitMessageNegativeRegex(`value`: Output<String>) {
        this.commitMessageNegativeRegex = value
    }

    /**
     * @param value All commit messages must match this regex, e.g. `Fixed \d+\..*`.
     */
    @JvmName("ekqlvtwhpwmirpna")
    public suspend fun commitMessageRegex(`value`: Output<String>) {
        this.commitMessageRegex = value
    }

    /**
     * @param value Deny deleting a tag.
     */
    @JvmName("fewibahdqqcarige")
    public suspend fun denyDeleteTag(`value`: Output<Boolean>) {
        this.denyDeleteTag = value
    }

    /**
     * @param value Filenames matching the regular expression provided in this attribute are not allowed, for example, `(jar|exe)$`.
     */
    @JvmName("mctpgnxrlwnmontm")
    public suspend fun fileNameRegex(`value`: Output<String>) {
        this.fileNameRegex = value
    }

    /**
     * @param value Maximum file size (MB) allowed.
     */
    @JvmName("nduedkedunyqsimt")
    public suspend fun maxFileSize(`value`: Output<Int>) {
        this.maxFileSize = value
    }

    /**
     * @param value Allows only GitLab users to author commits.
     */
    @JvmName("endlqesudwgspbcg")
    public suspend fun memberCheck(`value`: Output<Boolean>) {
        this.memberCheck = value
    }

    /**
     * @param value GitLab will reject any files that are likely to contain secrets.
     */
    @JvmName("ahcutbjgfxaqcrrg")
    public suspend fun preventSecrets(`value`: Output<Boolean>) {
        this.preventSecrets = value
    }

    /**
     * @param value Reject commit when it’s not DCO certified.
     */
    @JvmName("wgkkdvobdvwhvtng")
    public suspend fun rejectNonDcoCommits(`value`: Output<Boolean>) {
        this.rejectNonDcoCommits = value
    }

    /**
     * @param value Only commits signed through GPG are allowed.  **Note** This attribute is only supported in GitLab versions >= 16.4.
     */
    @JvmName("ptdrwfkupxeahqlb")
    public suspend fun rejectUnsignedCommits(`value`: Output<Boolean>) {
        this.rejectUnsignedCommits = value
    }

    /**
     * @param value All commit author emails must match this regex, e.g. `@my-company.com$`.
     */
    @JvmName("lcvjonntxleyuuyw")
    public suspend fun authorEmailRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorEmailRegex = mapped
    }

    /**
     * @param value All branch names must match this regex, e.g. `(feature|hotfix)\/*`.
     * */
     */
    @JvmName("ytetlemamriwegbg")
    public suspend fun branchNameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branchNameRegex = mapped
    }

    /**
     * @param value Only commits pushed using verified emails are allowed.  **Note** This attribute is only supported in GitLab versions >= 16.4.
     */
    @JvmName("udjjlajbgqjreavo")
    public suspend fun commitCommitterCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commitCommitterCheck = mapped
    }

    /**
     * @param value Users can only push commits to this repository if the commit author name is consistent with their GitLab account name.
     */
    @JvmName("ucyvtwwnljnppglr")
    public suspend fun commitCommitterNameCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commitCommitterNameCheck = mapped
    }

    /**
     * @param value No commit message is allowed to match this regex, for example `ssh\:\/\/`.
     */
    @JvmName("dhfohnfbqxuljihm")
    public suspend fun commitMessageNegativeRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commitMessageNegativeRegex = mapped
    }

    /**
     * @param value All commit messages must match this regex, e.g. `Fixed \d+\..*`.
     */
    @JvmName("ufnayrnobfbtwnrt")
    public suspend fun commitMessageRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commitMessageRegex = mapped
    }

    /**
     * @param value Deny deleting a tag.
     */
    @JvmName("qdfecepsxfhpmkhx")
    public suspend fun denyDeleteTag(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.denyDeleteTag = mapped
    }

    /**
     * @param value Filenames matching the regular expression provided in this attribute are not allowed, for example, `(jar|exe)$`.
     */
    @JvmName("gaidlyldyoyrlvbf")
    public suspend fun fileNameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileNameRegex = mapped
    }

    /**
     * @param value Maximum file size (MB) allowed.
     */
    @JvmName("vhljrrugctsrpvnp")
    public suspend fun maxFileSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxFileSize = mapped
    }

    /**
     * @param value Allows only GitLab users to author commits.
     */
    @JvmName("sysfhhtsfgjtxefc")
    public suspend fun memberCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberCheck = mapped
    }

    /**
     * @param value GitLab will reject any files that are likely to contain secrets.
     */
    @JvmName("bdwqqdfehidjiofp")
    public suspend fun preventSecrets(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preventSecrets = mapped
    }

    /**
     * @param value Reject commit when it’s not DCO certified.
     */
    @JvmName("thtwivlkxbafjlcv")
    public suspend fun rejectNonDcoCommits(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rejectNonDcoCommits = mapped
    }

    /**
     * @param value Only commits signed through GPG are allowed.  **Note** This attribute is only supported in GitLab versions >= 16.4.
     */
    @JvmName("tqhidtirqcidupkn")
    public suspend fun rejectUnsignedCommits(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rejectUnsignedCommits = mapped
    }

    internal fun build(): GroupPushRulesArgs = GroupPushRulesArgs(
        authorEmailRegex = authorEmailRegex,
        branchNameRegex = branchNameRegex,
        commitCommitterCheck = commitCommitterCheck,
        commitCommitterNameCheck = commitCommitterNameCheck,
        commitMessageNegativeRegex = commitMessageNegativeRegex,
        commitMessageRegex = commitMessageRegex,
        denyDeleteTag = denyDeleteTag,
        fileNameRegex = fileNameRegex,
        maxFileSize = maxFileSize,
        memberCheck = memberCheck,
        preventSecrets = preventSecrets,
        rejectNonDcoCommits = rejectNonDcoCommits,
        rejectUnsignedCommits = rejectUnsignedCommits,
    )
}
