@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.inputs.ProjectContainerExpirationPolicyArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cadence The cadence of the policy. Valid values are: `1d`, `7d`, `14d`, `1month`, `3month`.
 * @property enabled If true, the policy is enabled.
 * @property keepN The number of images to keep.
 * @property nameRegex The regular expression to match image names to delete.
 * @property nameRegexDelete The regular expression to match image names to delete.
 * @property nameRegexKeep The regular expression to match image names to keep.
 * @property nextRunAt The next time the policy will run.
 * @property olderThan The number of days to keep images.
 */
public data class ProjectContainerExpirationPolicyArgs(
    public val cadence: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val keepN: Output<Int>? = null,
    @Deprecated(
        message = """
  `name_regex` has been deprecated. Use `name_regex_delete` instead.
  """,
    )
    public val nameRegex: Output<String>? = null,
    public val nameRegexDelete: Output<String>? = null,
    public val nameRegexKeep: Output<String>? = null,
    public val nextRunAt: Output<String>? = null,
    public val olderThan: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.ProjectContainerExpirationPolicyArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.ProjectContainerExpirationPolicyArgs =
        com.pulumi.gitlab.inputs.ProjectContainerExpirationPolicyArgs.builder()
            .cadence(cadence?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .keepN(keepN?.applyValue({ args0 -> args0 }))
            .nameRegex(nameRegex?.applyValue({ args0 -> args0 }))
            .nameRegexDelete(nameRegexDelete?.applyValue({ args0 -> args0 }))
            .nameRegexKeep(nameRegexKeep?.applyValue({ args0 -> args0 }))
            .nextRunAt(nextRunAt?.applyValue({ args0 -> args0 }))
            .olderThan(olderThan?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectContainerExpirationPolicyArgs].
 */
@PulumiTagMarker
public class ProjectContainerExpirationPolicyArgsBuilder internal constructor() {
    private var cadence: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var keepN: Output<Int>? = null

    private var nameRegex: Output<String>? = null

    private var nameRegexDelete: Output<String>? = null

    private var nameRegexKeep: Output<String>? = null

    private var nextRunAt: Output<String>? = null

    private var olderThan: Output<String>? = null

    /**
     * @param value The cadence of the policy. Valid values are: `1d`, `7d`, `14d`, `1month`, `3month`.
     */
    @JvmName("bgnrikwefnbreveg")
    public suspend fun cadence(`value`: Output<String>) {
        this.cadence = value
    }

    /**
     * @param value If true, the policy is enabled.
     */
    @JvmName("kambonatehryiaug")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The number of images to keep.
     */
    @JvmName("jmjwxjhpmtpgwatu")
    public suspend fun keepN(`value`: Output<Int>) {
        this.keepN = value
    }

    /**
     * @param value The regular expression to match image names to delete.
     */
    @Deprecated(
        message = """
  `name_regex` has been deprecated. Use `name_regex_delete` instead.
  """,
    )
    @JvmName("apqgjlobnwaxmgrj")
    public suspend fun nameRegex(`value`: Output<String>) {
        this.nameRegex = value
    }

    /**
     * @param value The regular expression to match image names to delete.
     */
    @JvmName("cucnprornroisryv")
    public suspend fun nameRegexDelete(`value`: Output<String>) {
        this.nameRegexDelete = value
    }

    /**
     * @param value The regular expression to match image names to keep.
     */
    @JvmName("fukbglnfpnirrlck")
    public suspend fun nameRegexKeep(`value`: Output<String>) {
        this.nameRegexKeep = value
    }

    /**
     * @param value The next time the policy will run.
     */
    @JvmName("adrwfmukwfsdalfn")
    public suspend fun nextRunAt(`value`: Output<String>) {
        this.nextRunAt = value
    }

    /**
     * @param value The number of days to keep images.
     */
    @JvmName("eocdqduaflhyygwu")
    public suspend fun olderThan(`value`: Output<String>) {
        this.olderThan = value
    }

    /**
     * @param value The cadence of the policy. Valid values are: `1d`, `7d`, `14d`, `1month`, `3month`.
     */
    @JvmName("actomfsgembhdeso")
    public suspend fun cadence(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cadence = mapped
    }

    /**
     * @param value If true, the policy is enabled.
     */
    @JvmName("tamjfjcpxsyapssx")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The number of images to keep.
     */
    @JvmName("vsauacaejwupqiji")
    public suspend fun keepN(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keepN = mapped
    }

    /**
     * @param value The regular expression to match image names to delete.
     */
    @Deprecated(
        message = """
  `name_regex` has been deprecated. Use `name_regex_delete` instead.
  """,
    )
    @JvmName("hemdcmhnkllsjxtr")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nameRegex = mapped
    }

    /**
     * @param value The regular expression to match image names to delete.
     */
    @JvmName("tgdgrucrrwuafwbl")
    public suspend fun nameRegexDelete(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nameRegexDelete = mapped
    }

    /**
     * @param value The regular expression to match image names to keep.
     */
    @JvmName("gtbqcnjbfkeyqssd")
    public suspend fun nameRegexKeep(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nameRegexKeep = mapped
    }

    /**
     * @param value The next time the policy will run.
     */
    @JvmName("chlbtuncmnkalaup")
    public suspend fun nextRunAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextRunAt = mapped
    }

    /**
     * @param value The number of days to keep images.
     */
    @JvmName("moulgqcocwvebchl")
    public suspend fun olderThan(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.olderThan = mapped
    }

    internal fun build(): ProjectContainerExpirationPolicyArgs = ProjectContainerExpirationPolicyArgs(
        cadence = cadence,
        enabled = enabled,
        keepN = keepN,
        nameRegex = nameRegex,
        nameRegexDelete = nameRegexDelete,
        nameRegexKeep = nameRegexKeep,
        nextRunAt = nextRunAt,
        olderThan = olderThan,
    )
}
