@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.inputs.ProjectIssueBoardListArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property assigneeId The ID of the assignee the list should be scoped to. Requires a GitLab EE license.
 * @property id The ID of the list
 * @property iterationId The ID of the iteration the list should be scoped to. Requires a GitLab EE license.
 * @property labelId The ID of the label the list should be scoped to. Requires a GitLab EE license.
 * @property milestoneId The ID of the milestone the list should be scoped to. Requires a GitLab EE license.
 * @property position The position of the list within the board. The position for the list is based on the its position in the `lists` array.
 */
public data class ProjectIssueBoardListArgs(
    public val assigneeId: Output<Int>? = null,
    public val id: Output<Int>? = null,
    public val iterationId: Output<Int>? = null,
    public val labelId: Output<Int>? = null,
    public val milestoneId: Output<Int>? = null,
    public val position: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.ProjectIssueBoardListArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.ProjectIssueBoardListArgs =
        com.pulumi.gitlab.inputs.ProjectIssueBoardListArgs.builder()
            .assigneeId(assigneeId?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .iterationId(iterationId?.applyValue({ args0 -> args0 }))
            .labelId(labelId?.applyValue({ args0 -> args0 }))
            .milestoneId(milestoneId?.applyValue({ args0 -> args0 }))
            .position(position?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectIssueBoardListArgs].
 */
@PulumiTagMarker
public class ProjectIssueBoardListArgsBuilder internal constructor() {
    private var assigneeId: Output<Int>? = null

    private var id: Output<Int>? = null

    private var iterationId: Output<Int>? = null

    private var labelId: Output<Int>? = null

    private var milestoneId: Output<Int>? = null

    private var position: Output<Int>? = null

    /**
     * @param value The ID of the assignee the list should be scoped to. Requires a GitLab EE license.
     */
    @JvmName("wqqbegreupmlsnvu")
    public suspend fun assigneeId(`value`: Output<Int>) {
        this.assigneeId = value
    }

    /**
     * @param value The ID of the list
     */
    @JvmName("uudpstppxflmxamy")
    public suspend fun id(`value`: Output<Int>) {
        this.id = value
    }

    /**
     * @param value The ID of the iteration the list should be scoped to. Requires a GitLab EE license.
     */
    @JvmName("uqhwtyfrbmewmmsw")
    public suspend fun iterationId(`value`: Output<Int>) {
        this.iterationId = value
    }

    /**
     * @param value The ID of the label the list should be scoped to. Requires a GitLab EE license.
     */
    @JvmName("kuyoeapcsdnfmowi")
    public suspend fun labelId(`value`: Output<Int>) {
        this.labelId = value
    }

    /**
     * @param value The ID of the milestone the list should be scoped to. Requires a GitLab EE license.
     */
    @JvmName("crccoegwrpywvgro")
    public suspend fun milestoneId(`value`: Output<Int>) {
        this.milestoneId = value
    }

    /**
     * @param value The position of the list within the board. The position for the list is based on the its position in the `lists` array.
     */
    @JvmName("ccbgiwlmjauvouwq")
    public suspend fun position(`value`: Output<Int>) {
        this.position = value
    }

    /**
     * @param value The ID of the assignee the list should be scoped to. Requires a GitLab EE license.
     */
    @JvmName("rpxxhmhxhvmfeorn")
    public suspend fun assigneeId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assigneeId = mapped
    }

    /**
     * @param value The ID of the list
     */
    @JvmName("opsicxyladjumfsq")
    public suspend fun id(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The ID of the iteration the list should be scoped to. Requires a GitLab EE license.
     */
    @JvmName("ahxhkvasunwrpwjd")
    public suspend fun iterationId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iterationId = mapped
    }

    /**
     * @param value The ID of the label the list should be scoped to. Requires a GitLab EE license.
     */
    @JvmName("ujmevxupvymtietf")
    public suspend fun labelId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelId = mapped
    }

    /**
     * @param value The ID of the milestone the list should be scoped to. Requires a GitLab EE license.
     */
    @JvmName("cuascogndnmqehcu")
    public suspend fun milestoneId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.milestoneId = mapped
    }

    /**
     * @param value The position of the list within the board. The position for the list is based on the its position in the `lists` array.
     */
    @JvmName("jcvfjgeqippgyjpu")
    public suspend fun position(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.position = mapped
    }

    internal fun build(): ProjectIssueBoardListArgs = ProjectIssueBoardListArgs(
        assigneeId = assigneeId,
        id = id,
        iterationId = iterationId,
        labelId = labelId,
        milestoneId = milestoneId,
        position = position,
    )
}
