@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.inputs.ProjectPushRulesArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authorEmailRegex All commit author emails must match this regex, e.g. `@my-company.com$`.
 * @property branchNameRegex All branch names must match this regex, e.g. `(feature|hotfix)\/*`.
 * @property commitCommitterCheck Users can only push commits to this repository that were committed with one of their own verified emails.
 * @property commitCommitterNameCheck Users can only push commits to this repository if the commit author name is consistent with their GitLab account name.
 * @property commitMessageNegativeRegex No commit message is allowed to match this regex, e.g. `ssh\:\/\/`.
 * @property commitMessageRegex All commit messages must match this regex, e.g. `Fixed \d+\..*`.
 * @property denyDeleteTag Deny deleting a tag.
 * @property fileNameRegex All committed filenames must not match this regex, e.g. `(jar|exe)$`.
 * @property maxFileSize Maximum file size (MB).
 * @property memberCheck Restrict commits by author (email) to existing GitLab users.
 * @property preventSecrets GitLab will reject any files that are likely to contain secrets.
 * @property rejectNonDcoCommits Reject commit when it’s not DCO certified.
 * @property rejectUnsignedCommits Reject commit when it’s not signed through GPG.
 * */
 */
public data class ProjectPushRulesArgs(
    public val authorEmailRegex: Output<String>? = null,
    public val branchNameRegex: Output<String>? = null,
    public val commitCommitterCheck: Output<Boolean>? = null,
    public val commitCommitterNameCheck: Output<Boolean>? = null,
    public val commitMessageNegativeRegex: Output<String>? = null,
    public val commitMessageRegex: Output<String>? = null,
    public val denyDeleteTag: Output<Boolean>? = null,
    public val fileNameRegex: Output<String>? = null,
    public val maxFileSize: Output<Int>? = null,
    public val memberCheck: Output<Boolean>? = null,
    public val preventSecrets: Output<Boolean>? = null,
    public val rejectNonDcoCommits: Output<Boolean>? = null,
    public val rejectUnsignedCommits: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.ProjectPushRulesArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.ProjectPushRulesArgs =
        com.pulumi.gitlab.inputs.ProjectPushRulesArgs.builder()
            .authorEmailRegex(authorEmailRegex?.applyValue({ args0 -> args0 }))
            .branchNameRegex(branchNameRegex?.applyValue({ args0 -> args0 }))
            .commitCommitterCheck(commitCommitterCheck?.applyValue({ args0 -> args0 }))
            .commitCommitterNameCheck(commitCommitterNameCheck?.applyValue({ args0 -> args0 }))
            .commitMessageNegativeRegex(commitMessageNegativeRegex?.applyValue({ args0 -> args0 }))
            .commitMessageRegex(commitMessageRegex?.applyValue({ args0 -> args0 }))
            .denyDeleteTag(denyDeleteTag?.applyValue({ args0 -> args0 }))
            .fileNameRegex(fileNameRegex?.applyValue({ args0 -> args0 }))
            .maxFileSize(maxFileSize?.applyValue({ args0 -> args0 }))
            .memberCheck(memberCheck?.applyValue({ args0 -> args0 }))
            .preventSecrets(preventSecrets?.applyValue({ args0 -> args0 }))
            .rejectNonDcoCommits(rejectNonDcoCommits?.applyValue({ args0 -> args0 }))
            .rejectUnsignedCommits(rejectUnsignedCommits?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectPushRulesArgs].
 */
@PulumiTagMarker
public class ProjectPushRulesArgsBuilder internal constructor() {
    private var authorEmailRegex: Output<String>? = null

    private var branchNameRegex: Output<String>? = null

    private var commitCommitterCheck: Output<Boolean>? = null

    private var commitCommitterNameCheck: Output<Boolean>? = null

    private var commitMessageNegativeRegex: Output<String>? = null

    private var commitMessageRegex: Output<String>? = null

    private var denyDeleteTag: Output<Boolean>? = null

    private var fileNameRegex: Output<String>? = null

    private var maxFileSize: Output<Int>? = null

    private var memberCheck: Output<Boolean>? = null

    private var preventSecrets: Output<Boolean>? = null

    private var rejectNonDcoCommits: Output<Boolean>? = null

    private var rejectUnsignedCommits: Output<Boolean>? = null

    /**
     * @param value All commit author emails must match this regex, e.g. `@my-company.com$`.
     */
    @JvmName("ndvxeyrogfguhgup")
    public suspend fun authorEmailRegex(`value`: Output<String>) {
        this.authorEmailRegex = value
    }

    /**
     * @param value All branch names must match this regex, e.g. `(feature|hotfix)\/*`.
     * */
     */
    @JvmName("skxjoekypvxyprqv")
    public suspend fun branchNameRegex(`value`: Output<String>) {
        this.branchNameRegex = value
    }

    /**
     * @param value Users can only push commits to this repository that were committed with one of their own verified emails.
     */
    @JvmName("ngotkqqcoistrnnj")
    public suspend fun commitCommitterCheck(`value`: Output<Boolean>) {
        this.commitCommitterCheck = value
    }

    /**
     * @param value Users can only push commits to this repository if the commit author name is consistent with their GitLab account name.
     */
    @JvmName("qyumcyewyfrdibly")
    public suspend fun commitCommitterNameCheck(`value`: Output<Boolean>) {
        this.commitCommitterNameCheck = value
    }

    /**
     * @param value No commit message is allowed to match this regex, e.g. `ssh\:\/\/`.
     */
    @JvmName("gdjcsncujfpcplqh")
    public suspend fun commitMessageNegativeRegex(`value`: Output<String>) {
        this.commitMessageNegativeRegex = value
    }

    /**
     * @param value All commit messages must match this regex, e.g. `Fixed \d+\..*`.
     */
    @JvmName("veqrqnkdmalqrgvq")
    public suspend fun commitMessageRegex(`value`: Output<String>) {
        this.commitMessageRegex = value
    }

    /**
     * @param value Deny deleting a tag.
     */
    @JvmName("cqordtucxiinycdd")
    public suspend fun denyDeleteTag(`value`: Output<Boolean>) {
        this.denyDeleteTag = value
    }

    /**
     * @param value All committed filenames must not match this regex, e.g. `(jar|exe)$`.
     */
    @JvmName("cnttbtxtidwlbdxm")
    public suspend fun fileNameRegex(`value`: Output<String>) {
        this.fileNameRegex = value
    }

    /**
     * @param value Maximum file size (MB).
     */
    @JvmName("lnddpcrbpxbescls")
    public suspend fun maxFileSize(`value`: Output<Int>) {
        this.maxFileSize = value
    }

    /**
     * @param value Restrict commits by author (email) to existing GitLab users.
     */
    @JvmName("bvusoclqmfrlewjs")
    public suspend fun memberCheck(`value`: Output<Boolean>) {
        this.memberCheck = value
    }

    /**
     * @param value GitLab will reject any files that are likely to contain secrets.
     */
    @JvmName("rfqafplamgcpdqcv")
    public suspend fun preventSecrets(`value`: Output<Boolean>) {
        this.preventSecrets = value
    }

    /**
     * @param value Reject commit when it’s not DCO certified.
     */
    @JvmName("sonwnblseffnxubw")
    public suspend fun rejectNonDcoCommits(`value`: Output<Boolean>) {
        this.rejectNonDcoCommits = value
    }

    /**
     * @param value Reject commit when it’s not signed through GPG.
     */
    @JvmName("wfgnhbxlgrxssdcx")
    public suspend fun rejectUnsignedCommits(`value`: Output<Boolean>) {
        this.rejectUnsignedCommits = value
    }

    /**
     * @param value All commit author emails must match this regex, e.g. `@my-company.com$`.
     */
    @JvmName("timmhhdacksougtp")
    public suspend fun authorEmailRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorEmailRegex = mapped
    }

    /**
     * @param value All branch names must match this regex, e.g. `(feature|hotfix)\/*`.
     * */
     */
    @JvmName("txakpwtjpyiiujur")
    public suspend fun branchNameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branchNameRegex = mapped
    }

    /**
     * @param value Users can only push commits to this repository that were committed with one of their own verified emails.
     */
    @JvmName("lpqiouqjkdnlbnjs")
    public suspend fun commitCommitterCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commitCommitterCheck = mapped
    }

    /**
     * @param value Users can only push commits to this repository if the commit author name is consistent with their GitLab account name.
     */
    @JvmName("lclthetpsmirvacf")
    public suspend fun commitCommitterNameCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commitCommitterNameCheck = mapped
    }

    /**
     * @param value No commit message is allowed to match this regex, e.g. `ssh\:\/\/`.
     */
    @JvmName("muibmrpmebjtnrra")
    public suspend fun commitMessageNegativeRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commitMessageNegativeRegex = mapped
    }

    /**
     * @param value All commit messages must match this regex, e.g. `Fixed \d+\..*`.
     */
    @JvmName("lgncsyxmjjijikxd")
    public suspend fun commitMessageRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commitMessageRegex = mapped
    }

    /**
     * @param value Deny deleting a tag.
     */
    @JvmName("tkdvvnkpqfsjatsy")
    public suspend fun denyDeleteTag(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.denyDeleteTag = mapped
    }

    /**
     * @param value All committed filenames must not match this regex, e.g. `(jar|exe)$`.
     */
    @JvmName("cnjejsdfsttobpad")
    public suspend fun fileNameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileNameRegex = mapped
    }

    /**
     * @param value Maximum file size (MB).
     */
    @JvmName("ffcsquekrrocujqr")
    public suspend fun maxFileSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxFileSize = mapped
    }

    /**
     * @param value Restrict commits by author (email) to existing GitLab users.
     */
    @JvmName("tsbfklmuivgwprno")
    public suspend fun memberCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberCheck = mapped
    }

    /**
     * @param value GitLab will reject any files that are likely to contain secrets.
     */
    @JvmName("xqonrwhpmvesbbrh")
    public suspend fun preventSecrets(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preventSecrets = mapped
    }

    /**
     * @param value Reject commit when it’s not DCO certified.
     */
    @JvmName("lwhxlpbjckkibgym")
    public suspend fun rejectNonDcoCommits(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rejectNonDcoCommits = mapped
    }

    /**
     * @param value Reject commit when it’s not signed through GPG.
     */
    @JvmName("rlufvyhwjvkdjbvv")
    public suspend fun rejectUnsignedCommits(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rejectUnsignedCommits = mapped
    }

    internal fun build(): ProjectPushRulesArgs = ProjectPushRulesArgs(
        authorEmailRegex = authorEmailRegex,
        branchNameRegex = branchNameRegex,
        commitCommitterCheck = commitCommitterCheck,
        commitCommitterNameCheck = commitCommitterNameCheck,
        commitMessageNegativeRegex = commitMessageNegativeRegex,
        commitMessageRegex = commitMessageRegex,
        denyDeleteTag = denyDeleteTag,
        fileNameRegex = fileNameRegex,
        maxFileSize = maxFileSize,
        memberCheck = memberCheck,
        preventSecrets = preventSecrets,
        rejectNonDcoCommits = rejectNonDcoCommits,
        rejectUnsignedCommits = rejectUnsignedCommits,
    )
}
