@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowForcePush Allow force push for all users with push access.
 * @property allowedToMerges An array of access levels allowed to merge. Supports Developer (30) or Maintainer (40).
 * @property allowedToPushes An array of access levels allowed to push. Supports Developer (30) or Maintainer (40).
 * @property developerCanInitialPush Allow developers to initial push.
 */
public data class ApplicationSettingsDefaultBranchProtectionDefaults(
    public val allowForcePush: Boolean? = null,
    public val allowedToMerges: List<Any>? = null,
    public val allowedToPushes: List<Any>? = null,
    public val developerCanInitialPush: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.ApplicationSettingsDefaultBranchProtectionDefaults): ApplicationSettingsDefaultBranchProtectionDefaults =
            ApplicationSettingsDefaultBranchProtectionDefaults(
                allowForcePush = javaType.allowForcePush().map({ args0 -> args0 }).orElse(null),
                allowedToMerges = javaType.allowedToMerges().map({ args0 -> args0 }),
                allowedToPushes = javaType.allowedToPushes().map({ args0 -> args0 }),
                developerCanInitialPush = javaType.developerCanInitialPush().map({ args0 -> args0 }).orElse(null),
            )
    }
}
