@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property authorEmail The email of the author.
 * @property authorName The name of the author.
 * @property authoredDate The date which the commit was authored (format: yyyy-MM-ddTHH:mm:ssZ).
 * @property committedDate The date at which the commit was pushed (format: yyyy-MM-ddTHH:mm:ssZ).
 * @property committerEmail The email of the user that committed.
 * @property committerName The name of the user that committed.
 * @property id The unique id assigned to the commit by Gitlab.
 * @property message The commit message
 * @property parentIds The id of the parents of the commit
 * @property shortId The short id assigned to the commit by Gitlab.
 * @property title The title of the commit
 */
public data class BranchCommit(
    public val authorEmail: String? = null,
    public val authorName: String? = null,
    public val authoredDate: String? = null,
    public val committedDate: String? = null,
    public val committerEmail: String? = null,
    public val committerName: String? = null,
    public val id: String? = null,
    public val message: String? = null,
    public val parentIds: List<String>? = null,
    public val shortId: String? = null,
    public val title: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.BranchCommit): BranchCommit =
            BranchCommit(
                authorEmail = javaType.authorEmail().map({ args0 -> args0 }).orElse(null),
                authorName = javaType.authorName().map({ args0 -> args0 }).orElse(null),
                authoredDate = javaType.authoredDate().map({ args0 -> args0 }).orElse(null),
                committedDate = javaType.committedDate().map({ args0 -> args0 }).orElse(null),
                committerEmail = javaType.committerEmail().map({ args0 -> args0 }).orElse(null),
                committerName = javaType.committerName().map({ args0 -> args0 }).orElse(null),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                message = javaType.message().map({ args0 -> args0 }).orElse(null),
                parentIds = javaType.parentIds().map({ args0 -> args0 }),
                shortId = javaType.shortId().map({ args0 -> args0 }).orElse(null),
                title = javaType.title().map({ args0 -> args0 }).orElse(null),
            )
    }
}
