@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessLevel Access levels allowed to unprotect push to protected branch. Valid values are: `developer`, `maintainer`, `admin`.
 * @property accessLevelDescription Readable description of access level.
 * @property groupId The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
 * @property userId The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
 */
public data class BranchProtectionAllowedToUnprotect(
    public val accessLevel: String? = null,
    public val accessLevelDescription: String? = null,
    public val groupId: Int? = null,
    public val userId: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.BranchProtectionAllowedToUnprotect): BranchProtectionAllowedToUnprotect = BranchProtectionAllowedToUnprotect(
            accessLevel = javaType.accessLevel().map({ args0 -> args0 }).orElse(null),
            accessLevelDescription = javaType.accessLevelDescription().map({ args0 -> args0 }).orElse(null),
            groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
            userId = javaType.userId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
