@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getApplication.
 * @property applicationId Internal GitLab application id.
 * @property confidential Indicates if the application is kept confidential.
 * @property id
 * @property name The name of the GitLab application.
 * @property redirectUrl The redirect url of the application.
 */
public data class GetApplicationResult(
    public val applicationId: String,
    public val confidential: Boolean,
    public val id: String,
    public val name: String,
    public val redirectUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetApplicationResult): GetApplicationResult = GetApplicationResult(
            applicationId = javaType.applicationId(),
            confidential = javaType.confidential(),
            id = javaType.id(),
            name = javaType.name(),
            redirectUrl = javaType.redirectUrl(),
        )
    }
}
