@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBranch.
 * @property canPush Bool, true if you can push to the branch.
 * @property commits The commit associated with the branch ref.
 * @property default Bool, true if branch is the default branch for the project.
 * @property developerCanMerge Bool, true if developer level access allows to merge branch.
 * @property developerCanPush Bool, true if developer level access allows git push.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property merged Bool, true if the branch has been merged into it's parent.
 * @property name The name of the branch.
 * @property project The full path or id of the project.
 * @property protected Bool, true if branch has branch protection.
 * @property webUrl The url of the created branch (https.)
 */
public data class GetBranchResult(
    public val canPush: Boolean,
    public val commits: List<GetBranchCommit>,
    public val default: Boolean,
    public val developerCanMerge: Boolean,
    public val developerCanPush: Boolean,
    public val id: String,
    public val merged: Boolean,
    public val name: String,
    public val project: String,
    public val `protected`: Boolean,
    public val webUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetBranchResult): GetBranchResult =
            GetBranchResult(
                canPush = javaType.canPush(),
                commits = javaType.commits().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.gitlab.kotlin.outputs.GetBranchCommit.Companion.toKotlin(args0)
                    })
                }),
                default = javaType.default_(),
                developerCanMerge = javaType.developerCanMerge(),
                developerCanPush = javaType.developerCanPush(),
                id = javaType.id(),
                merged = javaType.merged(),
                name = javaType.name(),
                project = javaType.project(),
                `protected` = javaType.protected_(),
                webUrl = javaType.webUrl(),
            )
    }
}
