@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getClusterAgent.
 * @property agentId The ID of the agent.
 * @property createdAt The ISO8601 datetime when the agent was created.
 * @property createdByUserId The ID of the user who created the agent.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name The Name of the agent.
 * @property project ID or full path of the project maintained by the authenticated user.
 */
public data class GetClusterAgentResult(
    public val agentId: Int,
    public val createdAt: String,
    public val createdByUserId: Int,
    public val id: String,
    public val name: String,
    public val project: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetClusterAgentResult): GetClusterAgentResult = GetClusterAgentResult(
            agentId = javaType.agentId(),
            createdAt = javaType.createdAt(),
            createdByUserId = javaType.createdByUserId(),
            id = javaType.id(),
            name = javaType.name(),
            project = javaType.project(),
        )
    }
}
