@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property agentId The ID of the agent.
 * @property createdAt The ISO8601 datetime when the agent was created.
 * @property createdByUserId The ID of the user who created the agent.
 * @property name The Name of the agent.
 * @property project ID or full path of the project maintained by the authenticated user.
 */
public data class GetClusterAgentsClusterAgent(
    public val agentId: Int,
    public val createdAt: String,
    public val createdByUserId: Int,
    public val name: String,
    public val project: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetClusterAgentsClusterAgent): GetClusterAgentsClusterAgent = GetClusterAgentsClusterAgent(
            agentId = javaType.agentId(),
            createdAt = javaType.createdAt(),
            createdByUserId = javaType.createdByUserId(),
            name = javaType.name(),
            project = javaType.project(),
        )
    }
}
