@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getClusterAgents.
 * @property clusterAgents List of the registered agents.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property project The ID or full path of the project owned by the authenticated user.
 */
public data class GetClusterAgentsResult(
    public val clusterAgents: List<GetClusterAgentsClusterAgent>,
    public val id: String,
    public val project: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetClusterAgentsResult): GetClusterAgentsResult = GetClusterAgentsResult(
            clusterAgents = javaType.clusterAgents().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetClusterAgentsClusterAgent.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            project = javaType.project(),
        )
    }
}
