@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getComplianceFramework.
 * @property color Color representation of the compliance framework in hex format. e.g. #FCA121.
 * @property default Is the compliance framework the default framework for the group.
 * @property description Description for the compliance framework.
 * @property frameworkId Globally unique ID of the compliance framework.
 * @property id
 * @property name Name for the compliance framework.
 * @property namespacePath Full path of the namespace to where the compliance framework is.
 * @property pipelineConfigurationFullPath Full path of the compliance pipeline configuration stored in a project repository, such as `.gitlab/.compliance-gitlab-ci.yml@compliance/hipaa`. Format: `path/file.y[a]ml@group-name/project-name` **Note**: Ultimate license required.
 */
public data class GetComplianceFrameworkResult(
    public val color: String,
    public val default: Boolean,
    public val description: String,
    public val frameworkId: String,
    public val id: String,
    public val name: String,
    public val namespacePath: String,
    public val pipelineConfigurationFullPath: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetComplianceFrameworkResult): GetComplianceFrameworkResult = GetComplianceFrameworkResult(
            color = javaType.color(),
            default = javaType.default_(),
            description = javaType.description(),
            frameworkId = javaType.frameworkId(),
            id = javaType.id(),
            name = javaType.name(),
            namespacePath = javaType.namespacePath(),
            pipelineConfigurationFullPath = javaType.pipelineConfigurationFullPath(),
        )
    }
}
