@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getCurrentUser.
 * @property bot Indicates if the user is a bot.
 * @property globalId Global ID of the user. This is in the form of a GraphQL globally unique ID.
 * @property globalNamespaceId Personal namespace of the user. This is in the form of a GraphQL globally unique ID.
 * @property groupCount Group count for the user.
 * @property id ID of the user.
 * @property name Human-readable name of the user. Returns **** if the user is a project bot and the requester does not have permission to view the project.
 * @property namespaceId Personal namespace of the user.
 * @property publicEmail User’s public email.
 * @property username Username of the user. Unique within this instance of GitLab.
 */
public data class GetCurrentUserResult(
    public val bot: Boolean,
    public val globalId: String,
    public val globalNamespaceId: String,
    public val groupCount: Int,
    public val id: String,
    public val name: String,
    public val namespaceId: String,
    public val publicEmail: String,
    public val username: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetCurrentUserResult): GetCurrentUserResult = GetCurrentUserResult(
            bot = javaType.bot(),
            globalId = javaType.globalId(),
            globalNamespaceId = javaType.globalNamespaceId(),
            groupCount = javaType.groupCount(),
            id = javaType.id(),
            name = javaType.name(),
            namespaceId = javaType.namespaceId(),
            publicEmail = javaType.publicEmail(),
            username = javaType.username(),
        )
    }
}
