@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property confidentialIssuesEvents Invoke the hook for confidential issues events.
 * @property confidentialNoteEvents Invoke the hook for confidential notes events.
 * @property customWebhookTemplate Set a custom webhook template.
 * @property deploymentEvents Invoke the hook for deployment events.
 * @property enableSslVerification Enable ssl verification when invoking the hook.
 * @property group The ID or full path of the group.
 * @property groupId The id of the group for the hook.
 * @property hookId The id of the group hook.
 * @property issuesEvents Invoke the hook for issues events.
 * @property jobEvents Invoke the hook for job events.
 * @property mergeRequestsEvents Invoke the hook for merge requests.
 * @property noteEvents Invoke the hook for notes events.
 * @property pipelineEvents Invoke the hook for pipeline events.
 * @property pushEvents Invoke the hook for push events.
 * @property pushEventsBranchFilter Invoke the hook for push events on matching branches only.
 * @property releasesEvents Invoke the hook for releases events.
 * @property subgroupEvents Invoke the hook for subgroup events.
 * @property tagPushEvents Invoke the hook for tag push events.
 * @property token A token to present when invoking the hook. The token is not available for imported resources.
 * @property url The url of the hook to invoke.
 * @property wikiPageEvents Invoke the hook for wiki page events.
 */
public data class GetGroupHooksHook(
    public val confidentialIssuesEvents: Boolean,
    public val confidentialNoteEvents: Boolean,
    public val customWebhookTemplate: String,
    public val deploymentEvents: Boolean,
    public val enableSslVerification: Boolean,
    public val group: String,
    public val groupId: Int,
    public val hookId: Int,
    public val issuesEvents: Boolean,
    public val jobEvents: Boolean,
    public val mergeRequestsEvents: Boolean,
    public val noteEvents: Boolean,
    public val pipelineEvents: Boolean,
    public val pushEvents: Boolean,
    public val pushEventsBranchFilter: String,
    public val releasesEvents: Boolean,
    public val subgroupEvents: Boolean,
    public val tagPushEvents: Boolean,
    public val token: String,
    public val url: String,
    public val wikiPageEvents: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetGroupHooksHook): GetGroupHooksHook =
            GetGroupHooksHook(
                confidentialIssuesEvents = javaType.confidentialIssuesEvents(),
                confidentialNoteEvents = javaType.confidentialNoteEvents(),
                customWebhookTemplate = javaType.customWebhookTemplate(),
                deploymentEvents = javaType.deploymentEvents(),
                enableSslVerification = javaType.enableSslVerification(),
                group = javaType.group(),
                groupId = javaType.groupId(),
                hookId = javaType.hookId(),
                issuesEvents = javaType.issuesEvents(),
                jobEvents = javaType.jobEvents(),
                mergeRequestsEvents = javaType.mergeRequestsEvents(),
                noteEvents = javaType.noteEvents(),
                pipelineEvents = javaType.pipelineEvents(),
                pushEvents = javaType.pushEvents(),
                pushEventsBranchFilter = javaType.pushEventsBranchFilter(),
                releasesEvents = javaType.releasesEvents(),
                subgroupEvents = javaType.subgroupEvents(),
                tagPushEvents = javaType.tagPushEvents(),
                token = javaType.token(),
                url = javaType.url(),
                wikiPageEvents = javaType.wikiPageEvents(),
            )
    }
}
