@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getGroupHooks.
 * @property group The ID or full path of the group.
 * @property hooks The list of hooks.
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetGroupHooksResult(
    public val group: String,
    public val hooks: List<GetGroupHooksHook>,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetGroupHooksResult): GetGroupHooksResult = GetGroupHooksResult(
            group = javaType.group(),
            hooks = javaType.hooks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetGroupHooksHook.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
        )
    }
}
