@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getGroupIds.
 * @property group The ID or URL-encoded path of the group.
 * @property groupFullPath The full path of the group.
 * @property groupGraphqlId The GraphQL ID of the group.
 * @property groupId The ID of the group.
 * @property id
 */
public data class GetGroupIdsResult(
    public val group: String,
    public val groupFullPath: String,
    public val groupGraphqlId: String,
    public val groupId: String,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetGroupIdsResult): GetGroupIdsResult =
            GetGroupIdsResult(
                group = javaType.group(),
                groupFullPath = javaType.groupFullPath(),
                groupGraphqlId = javaType.groupGraphqlId(),
                groupId = javaType.groupId(),
                id = javaType.id(),
            )
    }
}
