@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessLevel The level of access to the group.
 * @property avatarUrl The avatar URL of the user.
 * @property expiresAt Expiration date for the group membership.
 * @property id The unique id assigned to the user by the gitlab server.
 * @property name The name of the user.
 * @property state Whether the user is active or blocked.
 * @property username The username of the user.
 * @property webUrl User's website URL.
 */
public data class GetGroupMembershipMember(
    public val accessLevel: String,
    public val avatarUrl: String,
    public val expiresAt: String,
    public val id: Int,
    public val name: String,
    public val state: String,
    public val username: String,
    public val webUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetGroupMembershipMember): GetGroupMembershipMember = GetGroupMembershipMember(
            accessLevel = javaType.accessLevel(),
            avatarUrl = javaType.avatarUrl(),
            expiresAt = javaType.expiresAt(),
            id = javaType.id(),
            name = javaType.name(),
            state = javaType.state(),
            username = javaType.username(),
            webUrl = javaType.webUrl(),
        )
    }
}
