@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getGroupMembership.
 * @property accessLevel Only return members with the desired access level. Acceptable values are: `guest`, `reporter`, `developer`, `maintainer`, `owner`.
 * @property fullPath The full path of the group.
 * @property groupId The ID of the group.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property inherited Return all project members including members through ancestor groups.
 * @property members The list of group members.
 */
public data class GetGroupMembershipResult(
    public val accessLevel: String,
    public val fullPath: String,
    public val groupId: Int,
    public val id: String,
    public val inherited: Boolean? = null,
    public val members: List<GetGroupMembershipMember>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetGroupMembershipResult): GetGroupMembershipResult = GetGroupMembershipResult(
            accessLevel = javaType.accessLevel(),
            fullPath = javaType.fullPath(),
            groupId = javaType.groupId(),
            id = javaType.id(),
            inherited = javaType.inherited().map({ args0 -> args0 }).orElse(null),
            members = javaType.members().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetGroupMembershipMember.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
