@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property expiresAt Share with group expiration date.
 * @property groupAccessLevel The access_level permission level of the shared group.
 * @property groupFullPath The full path of the group shared with.
 * @property groupId The ID of the group shared with.
 * @property groupName The name of the group shared with.
 */
public data class GetGroupSharedWithGroup(
    public val expiresAt: String,
    public val groupAccessLevel: Int,
    public val groupFullPath: String,
    public val groupId: Int,
    public val groupName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetGroupSharedWithGroup): GetGroupSharedWithGroup = GetGroupSharedWithGroup(
            expiresAt = javaType.expiresAt(),
            groupAccessLevel = javaType.groupAccessLevel(),
            groupFullPath = javaType.groupFullPath(),
            groupId = javaType.groupId(),
            groupName = javaType.groupName(),
        )
    }
}
