@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getGroupSubgroups.
 * @property allAvailable Show all the groups you have access to.
 * @property groupId The ID of the group.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property minAccessLevel Limit to groups where current user has at least this access level.
 * @property orderBy Order groups by name, path or id.
 * @property owned Limit to groups explicitly owned by the current user.
 * @property search Return the list of authorized groups matching the search criteria.
 * @property skipGroups Skip the group IDs passed.
 * @property sort Order groups in asc or desc order.
 * @property statistics Include group statistics (administrators only).
 * @property subgroups Subgroups of the parent group.
 * @property withCustomAttributes Include custom attributes in response (administrators only).
 */
public data class GetGroupSubgroupsResult(
    public val allAvailable: Boolean,
    public val groupId: Int,
    public val id: String,
    public val minAccessLevel: String,
    public val orderBy: String,
    public val owned: Boolean,
    public val search: String,
    public val skipGroups: List<Int>,
    public val sort: String,
    public val statistics: Boolean,
    public val subgroups: List<GetGroupSubgroupsSubgroup>,
    public val withCustomAttributes: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetGroupSubgroupsResult): GetGroupSubgroupsResult = GetGroupSubgroupsResult(
            allAvailable = javaType.allAvailable(),
            groupId = javaType.groupId(),
            id = javaType.id(),
            minAccessLevel = javaType.minAccessLevel(),
            orderBy = javaType.orderBy(),
            owned = javaType.owned(),
            search = javaType.search(),
            skipGroups = javaType.skipGroups().map({ args0 -> args0 }),
            sort = javaType.sort(),
            statistics = javaType.statistics(),
            subgroups = javaType.subgroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetGroupSubgroupsSubgroup.Companion.toKotlin(args0)
                })
            }),
            withCustomAttributes = javaType.withCustomAttributes(),
        )
    }
}
