@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property autoDevopsEnabled
 * @property avatarUrl
 * @property createdAt
 * @property defaultBranchProtection
 * @property description
 * @property emailsEnabled
 * @property fileTemplateProjectId
 * @property fullName
 * @property fullPath
 * @property groupId
 * @property ipRestrictionRanges
 * @property lfsEnabled
 * @property mentionsDisabled
 * @property name
 * @property parentId
 * @property path
 * @property projectCreationLevel
 * @property requestAccessEnabled
 * @property requireTwoFactorAuthentication
 * @property shareWithGroupLock
 * @property sharedRunnersSetting
 * @property statistics
 * @property subgroupCreationLevel
 * @property twoFactorGracePeriod
 * @property visibility
 * @property webUrl
 * @property wikiAccessLevel
 */
public data class GetGroupSubgroupsSubgroup(
    public val autoDevopsEnabled: Boolean,
    public val avatarUrl: String,
    public val createdAt: String,
    public val defaultBranchProtection: Int,
    public val description: String,
    public val emailsEnabled: Boolean,
    public val fileTemplateProjectId: Int,
    public val fullName: String,
    public val fullPath: String,
    public val groupId: Int,
    public val ipRestrictionRanges: String,
    public val lfsEnabled: Boolean,
    public val mentionsDisabled: Boolean,
    public val name: String,
    public val parentId: Int,
    public val path: String,
    public val projectCreationLevel: String,
    public val requestAccessEnabled: Boolean,
    public val requireTwoFactorAuthentication: Boolean,
    public val shareWithGroupLock: Boolean,
    public val sharedRunnersSetting: String,
    public val statistics: Map<String, String>,
    public val subgroupCreationLevel: String,
    public val twoFactorGracePeriod: Int,
    public val visibility: String,
    public val webUrl: String,
    public val wikiAccessLevel: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetGroupSubgroupsSubgroup): GetGroupSubgroupsSubgroup = GetGroupSubgroupsSubgroup(
            autoDevopsEnabled = javaType.autoDevopsEnabled(),
            avatarUrl = javaType.avatarUrl(),
            createdAt = javaType.createdAt(),
            defaultBranchProtection = javaType.defaultBranchProtection(),
            description = javaType.description(),
            emailsEnabled = javaType.emailsEnabled(),
            fileTemplateProjectId = javaType.fileTemplateProjectId(),
            fullName = javaType.fullName(),
            fullPath = javaType.fullPath(),
            groupId = javaType.groupId(),
            ipRestrictionRanges = javaType.ipRestrictionRanges(),
            lfsEnabled = javaType.lfsEnabled(),
            mentionsDisabled = javaType.mentionsDisabled(),
            name = javaType.name(),
            parentId = javaType.parentId(),
            path = javaType.path(),
            projectCreationLevel = javaType.projectCreationLevel(),
            requestAccessEnabled = javaType.requestAccessEnabled(),
            requireTwoFactorAuthentication = javaType.requireTwoFactorAuthentication(),
            shareWithGroupLock = javaType.shareWithGroupLock(),
            sharedRunnersSetting = javaType.sharedRunnersSetting(),
            statistics = javaType.statistics().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            subgroupCreationLevel = javaType.subgroupCreationLevel(),
            twoFactorGracePeriod = javaType.twoFactorGracePeriod(),
            visibility = javaType.visibility(),
            webUrl = javaType.webUrl(),
            wikiAccessLevel = javaType.wikiAccessLevel(),
        )
    }
}
