@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getGroupVariable.
 * @property description The description of the variable.
 * @property environmentScope The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
 * @property group The name or id of the group.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property key The name of the variable.
 * @property masked If set to `true`, the value of the variable will be hidden in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ee/ci/variables/#masked-variables). Defaults to `false`.
 * @property protected If set to `true`, the variable will be passed only to pipelines running on protected branches and tags. Defaults to `false`.
 * @property raw Whether the variable is treated as a raw string. Default: false. When true, variables in the value are not expanded.
 * @property value The value of the variable.
 * @property variableType The type of a variable. Valid values are: `env_var`, `file`. Default is `env_var`.
 */
public data class GetGroupVariableResult(
    public val description: String,
    public val environmentScope: String,
    public val group: String,
    public val id: String,
    public val key: String,
    public val masked: Boolean,
    public val `protected`: Boolean,
    public val raw: Boolean,
    public val `value`: String,
    public val variableType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetGroupVariableResult): GetGroupVariableResult = GetGroupVariableResult(
            description = javaType.description(),
            environmentScope = javaType.environmentScope(),
            group = javaType.group(),
            id = javaType.id(),
            key = javaType.key(),
            masked = javaType.masked(),
            `protected` = javaType.protected_(),
            raw = javaType.raw(),
            `value` = javaType.`value`(),
            variableType = javaType.variableType(),
        )
    }
}
