@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getGroupVariables.
 * @property environmentScope The environment scope of the variable. Defaults to all environment (`*`).
 * @property group The name or id of the group.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property variables The list of variables returned by the search
 */
public data class GetGroupVariablesResult(
    public val environmentScope: String? = null,
    public val group: String,
    public val id: String,
    public val variables: List<GetGroupVariablesVariable>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetGroupVariablesResult): GetGroupVariablesResult = GetGroupVariablesResult(
            environmentScope = javaType.environmentScope().map({ args0 -> args0 }).orElse(null),
            group = javaType.group(),
            id = javaType.id(),
            variables = javaType.variables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetGroupVariablesVariable.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
