@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property defaultBranchProtection Whether developers and maintainers can push to the applicable default branch.
 * @property description The description of the group.
 * @property fullName The full name of the group.
 * @property fullPath The full path of the group.
 * @property groupId The ID of the group.
 * @property lfsEnabled Boolean, is LFS enabled for projects in this group.
 * @property name The name of this group.
 * @property parentId Integer, ID of the parent group.
 * @property path The path of the group.
 * @property preventForkingOutsideGroup When enabled, users can not fork projects from this group to external namespaces.
 * @property requestAccessEnabled Boolean, is request for access enabled to the group.
 * @property runnersToken The group level registration token to use during runner setup.
 * @property sharedRunnersSetting Enable or disable shared runners for a group’s subgroups and projects. Valid values are: `enabled`, `disabled_and_overridable`, `disabled_and_unoverridable`, `disabled_with_override`.
 * @property visibilityLevel Visibility level of the group. Possible values are `private`, `internal`, `public`.
 * @property webUrl Web URL of the group.
 * @property wikiAccessLevel The group's wiki access level. Only available on Premium and Ultimate plans. Valid values are `disabled`, `private`, `enabled`.
 */
public data class GetGroupsGroup(
    public val defaultBranchProtection: Int,
    public val description: String,
    public val fullName: String,
    public val fullPath: String,
    public val groupId: Int,
    public val lfsEnabled: Boolean,
    public val name: String,
    public val parentId: Int,
    public val path: String,
    public val preventForkingOutsideGroup: Boolean,
    public val requestAccessEnabled: Boolean,
    public val runnersToken: String,
    public val sharedRunnersSetting: String,
    public val visibilityLevel: String,
    public val webUrl: String,
    public val wikiAccessLevel: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetGroupsGroup): GetGroupsGroup =
            GetGroupsGroup(
                defaultBranchProtection = javaType.defaultBranchProtection(),
                description = javaType.description(),
                fullName = javaType.fullName(),
                fullPath = javaType.fullPath(),
                groupId = javaType.groupId(),
                lfsEnabled = javaType.lfsEnabled(),
                name = javaType.name(),
                parentId = javaType.parentId(),
                path = javaType.path(),
                preventForkingOutsideGroup = javaType.preventForkingOutsideGroup(),
                requestAccessEnabled = javaType.requestAccessEnabled(),
                runnersToken = javaType.runnersToken(),
                sharedRunnersSetting = javaType.sharedRunnersSetting(),
                visibilityLevel = javaType.visibilityLevel(),
                webUrl = javaType.webUrl(),
                wikiAccessLevel = javaType.wikiAccessLevel(),
            )
    }
}
