@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getGroups.
 * @property groups The list of groups.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property orderBy Order the groups' list by `id`, `name`, `path`, or `similarity`. (Requires administrator privileges)
 * @property search Search groups by name or path.
 * @property sort Sort groups' list in asc or desc order. (Requires administrator privileges)
 * @property topLevelOnly Limit to top level groups, excluding all subgroups.
 */
public data class GetGroupsResult(
    public val groups: List<GetGroupsGroup>,
    public val id: String,
    public val orderBy: String? = null,
    public val search: String? = null,
    public val sort: String? = null,
    public val topLevelOnly: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetGroupsResult): GetGroupsResult =
            GetGroupsResult(
                groups = javaType.groups().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.gitlab.kotlin.outputs.GetGroupsGroup.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                orderBy = javaType.orderBy().map({ args0 -> args0 }).orElse(null),
                search = javaType.search().map({ args0 -> args0 }).orElse(null),
                sort = javaType.sort().map({ args0 -> args0 }).orElse(null),
                topLevelOnly = javaType.topLevelOnly().map({ args0 -> args0 }).orElse(null),
            )
    }
}
