@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property createdAt The creation date of the deploy key. In RFC3339 format.
 * @property fingerprint The fingerprint of the deploy key.
 * @property id The ID of the deploy key.
 * @property key The deploy key.
 * @property projectsWithWriteAccesses The list of projects that the deploy key has write access to.
 * @property title The title of the deploy key.
 */
public data class GetInstanceDeployKeysDeployKey(
    public val createdAt: String,
    public val fingerprint: String,
    public val id: Int,
    public val key: String,
    public val projectsWithWriteAccesses: List<GetInstanceDeployKeysDeployKeyProjectsWithWriteAccess>,
    public val title: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetInstanceDeployKeysDeployKey): GetInstanceDeployKeysDeployKey = GetInstanceDeployKeysDeployKey(
            createdAt = javaType.createdAt(),
            fingerprint = javaType.fingerprint(),
            id = javaType.id(),
            key = javaType.key(),
            projectsWithWriteAccesses = javaType.projectsWithWriteAccesses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetInstanceDeployKeysDeployKeyProjectsWithWriteAccess.Companion.toKotlin(args0)
                })
            }),
            title = javaType.title(),
        )
    }
}
