@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createdAt The creation date of the project. In RFC3339 format.
 * @property description The description of the project.
 * @property id The ID of the project.
 * @property name The name of the project.
 * @property nameWithNamespace The name of the project with namespace.
 * @property path The path of the project.
 * @property pathWithNamespace The path of the project with namespace.
 */
public data class GetInstanceDeployKeysDeployKeyProjectsWithWriteAccess(
    public val createdAt: String,
    public val description: String,
    public val id: Int,
    public val name: String,
    public val nameWithNamespace: String,
    public val path: String,
    public val pathWithNamespace: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetInstanceDeployKeysDeployKeyProjectsWithWriteAccess): GetInstanceDeployKeysDeployKeyProjectsWithWriteAccess =
            GetInstanceDeployKeysDeployKeyProjectsWithWriteAccess(
                createdAt = javaType.createdAt(),
                description = javaType.description(),
                id = javaType.id(),
                name = javaType.name(),
                nameWithNamespace = javaType.nameWithNamespace(),
                path = javaType.path(),
                pathWithNamespace = javaType.pathWithNamespace(),
            )
    }
}
