@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceDeployKeys.
 * @property deployKeys The list of all deploy keys across all projects of the GitLab instance.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property public Only return deploy keys that are public.
 */
public data class GetInstanceDeployKeysResult(
    public val deployKeys: List<GetInstanceDeployKeysDeployKey>,
    public val id: String,
    public val `public`: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetInstanceDeployKeysResult): GetInstanceDeployKeysResult = GetInstanceDeployKeysResult(
            deployKeys = javaType.deployKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetInstanceDeployKeysDeployKey.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            `public` = javaType.public_().map({ args0 -> args0 }).orElse(null),
        )
    }
}
