@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceVariables.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property variables The list of variables returned by the search
 */
public data class GetInstanceVariablesResult(
    public val id: String,
    public val variables: List<GetInstanceVariablesVariable>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetInstanceVariablesResult): GetInstanceVariablesResult = GetInstanceVariablesResult(
            id = javaType.id(),
            variables = javaType.variables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetInstanceVariablesVariable.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
