@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Indicates whether KAS is enabled.
 * @property externalUrl URL used by the agents to communicate with KAS. It’s null if kas.enabled is false.
 * @property version Version of KAS. It’s null if kas.enabled is false.
 */
public data class GetMetadataKas(
    public val enabled: Boolean,
    public val externalUrl: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetMetadataKas): GetMetadataKas =
            GetMetadataKas(
                enabled = javaType.enabled(),
                externalUrl = javaType.externalUrl(),
                version = javaType.version(),
            )
    }
}
