@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getMetadata.
 * @property enterprise If the GitLab instance is an enterprise instance or not. Supported for GitLab 15.6 onwards.
 * @property id The id of the data source. It will always be `1`
 * @property kas Metadata about the GitLab agent server for Kubernetes (KAS).
 * @property revision Revision of the GitLab instance.
 * @property version Version of the GitLab instance.
 */
public data class GetMetadataResult(
    public val enterprise: Boolean,
    public val id: String,
    public val kas: GetMetadataKas,
    public val revision: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetMetadataResult): GetMetadataResult =
            GetMetadataResult(
                enterprise = javaType.enterprise(),
                id = javaType.id(),
                kas = javaType.kas().let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetMetadataKas.Companion.toKotlin(args0)
                }),
                revision = javaType.revision(),
                version = javaType.version(),
            )
    }
}
