@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The pipeline ID.
 * @property ref The ref of the pipeline.
 * @property sha The SHA of the pipeline.
 * @property status The status of pipelines, one of: created, waiting*for*resource, preparing, pending, running, success, failed, canceled, skipped, manual, scheduled.
 */
public data class GetPipelineScheduleLastPipeline(
    public val id: Int,
    public val ref: String,
    public val sha: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetPipelineScheduleLastPipeline): GetPipelineScheduleLastPipeline = GetPipelineScheduleLastPipeline(
            id = javaType.id(),
            ref = javaType.ref(),
            sha = javaType.sha(),
            status = javaType.status(),
        )
    }
}
