@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPipelineSchedule.
 * @property active The activation status of pipeline schedule.
 * @property createdAt The datetime of when the schedule was created.
 * @property cron The cron (e.g. `0 1 * * *`).
 * @property cronTimezone The timezone.
 * @property description The description of the pipeline schedule.
 * @property id
 * @property lastPipeline The details of the last pipeline run by the schedule.
 * @property nextRunAt The datetime of when the schedule will next run.
 * @property owner The details of the pipeline schedule owner.
 * @property pipelineScheduleId The pipeline schedule id.
 * @property project The name or id of the project to add the schedule to.
 * @property ref The branch/tag name to be triggered. This will be the full branch reference, for example: `refs/heads/main`, not `main`.
 * @property updatedAt The datetime of when the schedule was last updated.
 * @property variables The list of the pipeline schedule variables.
 */
public data class GetPipelineScheduleResult(
    public val active: Boolean,
    public val createdAt: String,
    public val cron: String,
    public val cronTimezone: String,
    public val description: String,
    public val id: String,
    public val lastPipeline: GetPipelineScheduleLastPipeline,
    public val nextRunAt: String,
    public val owner: GetPipelineScheduleOwner,
    public val pipelineScheduleId: Int,
    public val project: String,
    public val ref: String,
    public val updatedAt: String,
    public val variables: List<GetPipelineScheduleVariable>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetPipelineScheduleResult): GetPipelineScheduleResult = GetPipelineScheduleResult(
            active = javaType.active(),
            createdAt = javaType.createdAt(),
            cron = javaType.cron(),
            cronTimezone = javaType.cronTimezone(),
            description = javaType.description(),
            id = javaType.id(),
            lastPipeline = javaType.lastPipeline().let({ args0 ->
                com.pulumi.gitlab.kotlin.outputs.GetPipelineScheduleLastPipeline.Companion.toKotlin(args0)
            }),
            nextRunAt = javaType.nextRunAt(),
            owner = javaType.owner().let({ args0 ->
                com.pulumi.gitlab.kotlin.outputs.GetPipelineScheduleOwner.Companion.toKotlin(args0)
            }),
            pipelineScheduleId = javaType.pipelineScheduleId(),
            project = javaType.project(),
            ref = javaType.ref(),
            updatedAt = javaType.updatedAt(),
            variables = javaType.variables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetPipelineScheduleVariable.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
