@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property key The key of a variable.
 * @property value The value of a variable.
 * @property variableType The type of a variable, one of: env_var and file.
 */
public data class GetPipelineScheduleVariable(
    public val key: String,
    public val `value`: String,
    public val variableType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetPipelineScheduleVariable): GetPipelineScheduleVariable = GetPipelineScheduleVariable(
            key = javaType.key(),
            `value` = javaType.`value`(),
            variableType = javaType.variableType(),
        )
    }
}
