@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property active The activation status of pipeline schedule.
 * @property createdAt The datetime of when the schedule was created.
 * @property cron The cron (e.g. `0 1 * * *`).
 * @property cronTimezone The timezone.
 * @property description The description of the pipeline schedule.
 * @property id The pipeline schedule id.
 * @property nextRunAt The datetime of when the schedule will next run.
 * @property owner The details of the pipeline schedule owner.
 * @property ref The branch/tag name to be triggered. This will be the full branch reference, for example: `refs/heads/main`, not `main`.
 * @property updatedAt The datetime of when the schedule was last updated.
 */
public data class GetPipelineSchedulesPipelineSchedule(
    public val active: Boolean,
    public val createdAt: String,
    public val cron: String,
    public val cronTimezone: String,
    public val description: String,
    public val id: String,
    public val nextRunAt: String,
    public val owner: GetPipelineSchedulesPipelineScheduleOwner,
    public val ref: String,
    public val updatedAt: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetPipelineSchedulesPipelineSchedule): GetPipelineSchedulesPipelineSchedule = GetPipelineSchedulesPipelineSchedule(
            active = javaType.active(),
            createdAt = javaType.createdAt(),
            cron = javaType.cron(),
            cronTimezone = javaType.cronTimezone(),
            description = javaType.description(),
            id = javaType.id(),
            nextRunAt = javaType.nextRunAt(),
            owner = javaType.owner().let({ args0 ->
                com.pulumi.gitlab.kotlin.outputs.GetPipelineSchedulesPipelineScheduleOwner.Companion.toKotlin(args0)
            }),
            ref = javaType.ref(),
            updatedAt = javaType.updatedAt(),
        )
    }
}
