@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property avatarUrl Image URL for the user's avatar.
 * @property id The user ID.
 * @property name Name.
 * @property state User's state, one of: active, blocked.
 * @property username Username.
 * @property webUrl URL to the user's profile.
 */
public data class GetPipelineSchedulesPipelineScheduleOwner(
    public val avatarUrl: String,
    public val id: Int,
    public val name: String,
    public val state: String,
    public val username: String,
    public val webUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetPipelineSchedulesPipelineScheduleOwner): GetPipelineSchedulesPipelineScheduleOwner = GetPipelineSchedulesPipelineScheduleOwner(
            avatarUrl = javaType.avatarUrl(),
            id = javaType.id(),
            name = javaType.name(),
            state = javaType.state(),
            username = javaType.username(),
            webUrl = javaType.webUrl(),
        )
    }
}
