@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPipelineSchedules.
 * @property id
 * @property pipelineSchedules The list of pipeline schedules.
 * @property project The name or id of the project to add the schedule to.
 */
public data class GetPipelineSchedulesResult(
    public val id: String,
    public val pipelineSchedules: List<GetPipelineSchedulesPipelineSchedule>,
    public val project: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetPipelineSchedulesResult): GetPipelineSchedulesResult = GetPipelineSchedulesResult(
            id = javaType.id(),
            pipelineSchedules = javaType.pipelineSchedules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetPipelineSchedulesPipelineSchedule.Companion.toKotlin(args0)
                })
            }),
            project = javaType.project(),
        )
    }
}
