@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property canPush Bool, true if you can push to the branch.
 * @property commits The commit associated with this branch.
 * @property default Bool, true if branch is the default branch for the project.
 * @property developersCanMerge Bool, true if developer level access allows to merge branch.
 * @property developersCanPush Bool, true if developer level access allows git push.
 * @property merged Bool, true if the branch has been merged into it's parent.
 * @property name The name of the branch.
 * @property protected Bool, true if branch has branch protection.
 * @property webUrl URL that can be used to find the branch in a browser.
 */
public data class GetProjectBranchesBranch(
    public val canPush: Boolean,
    public val commits: List<GetProjectBranchesBranchCommit>,
    public val default: Boolean,
    public val developersCanMerge: Boolean,
    public val developersCanPush: Boolean,
    public val merged: Boolean,
    public val name: String,
    public val `protected`: Boolean,
    public val webUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectBranchesBranch): GetProjectBranchesBranch = GetProjectBranchesBranch(
            canPush = javaType.canPush(),
            commits = javaType.commits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectBranchesBranchCommit.Companion.toKotlin(args0)
                })
            }),
            default = javaType.default_(),
            developersCanMerge = javaType.developersCanMerge(),
            developersCanPush = javaType.developersCanPush(),
            merged = javaType.merged(),
            name = javaType.name(),
            `protected` = javaType.protected_(),
            webUrl = javaType.webUrl(),
        )
    }
}
