@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProjectBranches.
 * @property branches The list of branches of the project, as defined below.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property project ID or URL-encoded path of the project owned by the authenticated user.
 */
public data class GetProjectBranchesResult(
    public val branches: List<GetProjectBranchesBranch>,
    public val id: String,
    public val project: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectBranchesResult): GetProjectBranchesResult = GetProjectBranchesResult(
            branches = javaType.branches().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectBranchesBranch.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            project = javaType.project(),
        )
    }
}
