@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cadence The cadence of the policy. Valid values are: `1d`, `7d`, `14d`, `1month`, `3month`.
 * @property enabled If true, the policy is enabled.
 * @property keepN The number of images to keep.
 * @property nameRegex The regular expression to match image names to delete.
 * @property nameRegexDelete The regular expression to match image names to delete.
 * @property nameRegexKeep The regular expression to match image names to keep.
 * @property nextRunAt The next time the policy will run.
 * @property olderThan The number of days to keep images.
 */
public data class GetProjectContainerExpirationPolicy(
    public val cadence: String,
    public val enabled: Boolean,
    public val keepN: Int,
    @Deprecated(
        message = """
  `name_regex` has been deprecated. Use `name_regex_delete` instead.
  """,
    )
    public val nameRegex: String,
    public val nameRegexDelete: String,
    public val nameRegexKeep: String,
    public val nextRunAt: String,
    public val olderThan: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectContainerExpirationPolicy): GetProjectContainerExpirationPolicy = GetProjectContainerExpirationPolicy(
            cadence = javaType.cadence(),
            enabled = javaType.enabled(),
            keepN = javaType.keepN(),
            nameRegex = javaType.nameRegex(),
            nameRegexDelete = javaType.nameRegexDelete(),
            nameRegexKeep = javaType.nameRegexKeep(),
            nextRunAt = javaType.nextRunAt(),
            olderThan = javaType.olderThan(),
        )
    }
}
