@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProjectHooks.
 * @property hooks The list of hooks.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property project The name or id of the project.
 */
public data class GetProjectHooksResult(
    public val hooks: List<GetProjectHooksHook>,
    public val id: String,
    public val project: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectHooksResult): GetProjectHooksResult = GetProjectHooksResult(
            hooks = javaType.hooks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectHooksHook.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            project = javaType.project(),
        )
    }
}
