@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getProjectIds.
 * @property id
 * @property project The ID or URL-encoded path of the project.
 * @property projectFullPath The full path of the project.
 * @property projectGraphqlId The GraphQL ID of the project.
 * @property projectId The ID of the project.
 */
public data class GetProjectIdsResult(
    public val id: String,
    public val project: String,
    public val projectFullPath: String,
    public val projectGraphqlId: String,
    public val projectId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectIdsResult): GetProjectIdsResult = GetProjectIdsResult(
            id = javaType.id(),
            project = javaType.project(),
            projectFullPath = javaType.projectFullPath(),
            projectGraphqlId = javaType.projectGraphqlId(),
            projectId = javaType.projectId(),
        )
    }
}
