@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getProjectIssue.
 * @property assigneeIds The IDs of the users to assign the issue to.
 * @property authorId The ID of the author of the issue. Use `gitlab.User` data source to get more information about the user.
 * @property closedAt When the issue was closed. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
 * @property closedByUserId The ID of the user that closed the issue. Use `gitlab.User` data source to get more information about the user.
 * @property confidential Set an issue to be confidential.
 * @property createdAt When the issue was created. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z. Requires administrator or project/group owner rights.
 * @property description The description of an issue. Limited to 1,048,576 characters.
 * @property discussionLocked Whether the issue is locked for discussions or not.
 * @property discussionToResolve The ID of a discussion to resolve. This fills out the issue with a default description and mark the discussion as resolved. Use in combination with merge*request*to*resolve*discussions_of.
 * @property downvotes The number of downvotes the issue has received.
 * @property dueDate The due date. Date time string in the format YYYY-MM-DD, for example 2016-03-11.
 * @property epicId ID of the epic to add the issue to. Valid values are greater than or equal to 0.
 * @property epicIssueId The ID of the epic issue.
 * @property externalId The external ID of the issue.
 * @property humanTimeEstimate The human-readable time estimate of the issue.
 * @property humanTotalTimeSpent The human-readable total time spent of the issue.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property iid The internal ID of the project's issue.
 * @property issueId The instance-wide ID of the issue.
 * @property issueLinkId The ID of the issue link.
 * @property issueType The type of issue. Valid values are: `issue`, `incident`, `test_case`.
 * @property labels The labels of an issue.
 * @property links The links of the issue.
 * @property mergeRequestToResolveDiscussionsOf The IID of a merge request in which to resolve all issues. This fills out the issue with a default description and mark all discussions as resolved. When passing a description or title, these values take precedence over the default values.
 * @property mergeRequestsCount The number of merge requests associated with the issue.
 * @property milestoneId The global ID of a milestone to assign issue. To find the milestone_id associated with a milestone, view an issue with the milestone assigned and use the API to retrieve the issue's details.
 * @property movedToId The ID of the issue that was moved to.
 * @property project The name or ID of the project.
 * @property references The references of the issue.
 * @property state The state of the issue. Valid values are: `opened`, `closed`.
 * @property subscribed Whether the authenticated user is subscribed to the issue or not.
 * @property taskCompletionStatuses The task completion status. It's always a one element list.
 * @property timeEstimate The time estimate of the issue.
 * @property title The title of the issue.
 * @property totalTimeSpent The total time spent of the issue.
 * @property updatedAt When the issue was updated. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
 * @property upvotes The number of upvotes the issue has received.
 * @property userNotesCount The number of user notes on the issue.
 * @property webUrl The web URL of the issue.
 * @property weight The weight of the issue. Valid values are greater than or equal to 0.
 */
public data class GetProjectIssueResult(
    public val assigneeIds: List<Int>,
    public val authorId: Int,
    public val closedAt: String,
    public val closedByUserId: Int,
    public val confidential: Boolean,
    public val createdAt: String,
    public val description: String,
    public val discussionLocked: Boolean,
    public val discussionToResolve: String,
    public val downvotes: Int,
    public val dueDate: String,
    public val epicId: Int,
    public val epicIssueId: Int,
    public val externalId: String,
    public val humanTimeEstimate: String,
    public val humanTotalTimeSpent: String,
    public val id: String,
    public val iid: Int,
    public val issueId: Int,
    public val issueLinkId: Int,
    public val issueType: String,
    public val labels: List<String>,
    public val links: Map<String, String>,
    public val mergeRequestToResolveDiscussionsOf: Int,
    public val mergeRequestsCount: Int,
    public val milestoneId: Int,
    public val movedToId: Int,
    public val project: String,
    public val references: Map<String, String>,
    public val state: String,
    public val subscribed: Boolean,
    public val taskCompletionStatuses: List<GetProjectIssueTaskCompletionStatus>,
    public val timeEstimate: Int,
    public val title: String,
    public val totalTimeSpent: Int,
    public val updatedAt: String,
    public val upvotes: Int,
    public val userNotesCount: Int,
    public val webUrl: String,
    public val weight: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectIssueResult): GetProjectIssueResult = GetProjectIssueResult(
            assigneeIds = javaType.assigneeIds().map({ args0 -> args0 }),
            authorId = javaType.authorId(),
            closedAt = javaType.closedAt(),
            closedByUserId = javaType.closedByUserId(),
            confidential = javaType.confidential(),
            createdAt = javaType.createdAt(),
            description = javaType.description(),
            discussionLocked = javaType.discussionLocked(),
            discussionToResolve = javaType.discussionToResolve(),
            downvotes = javaType.downvotes(),
            dueDate = javaType.dueDate(),
            epicId = javaType.epicId(),
            epicIssueId = javaType.epicIssueId(),
            externalId = javaType.externalId(),
            humanTimeEstimate = javaType.humanTimeEstimate(),
            humanTotalTimeSpent = javaType.humanTotalTimeSpent(),
            id = javaType.id(),
            iid = javaType.iid(),
            issueId = javaType.issueId(),
            issueLinkId = javaType.issueLinkId(),
            issueType = javaType.issueType(),
            labels = javaType.labels().map({ args0 -> args0 }),
            links = javaType.links().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            mergeRequestToResolveDiscussionsOf = javaType.mergeRequestToResolveDiscussionsOf(),
            mergeRequestsCount = javaType.mergeRequestsCount(),
            milestoneId = javaType.milestoneId(),
            movedToId = javaType.movedToId(),
            project = javaType.project(),
            references = javaType.references().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            state = javaType.state(),
            subscribed = javaType.subscribed(),
            taskCompletionStatuses = javaType.taskCompletionStatuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectIssueTaskCompletionStatus.Companion.toKotlin(args0)
                })
            }),
            timeEstimate = javaType.timeEstimate(),
            title = javaType.title(),
            totalTimeSpent = javaType.totalTimeSpent(),
            updatedAt = javaType.updatedAt(),
            upvotes = javaType.upvotes(),
            userNotesCount = javaType.userNotesCount(),
            webUrl = javaType.webUrl(),
            weight = javaType.weight(),
        )
    }
}
