@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProjectIssues.
 * @property assigneeId Return issues assigned to the given user id. Mutually exclusive with assignee_username. None returns unassigned issues. Any returns issues with an assignee.
 * @property assigneeUsername Return issues assigned to the given username. Similar to assignee*id and mutually exclusive with assignee*id. In GitLab CE, the assignee_username array should only contain a single value. Otherwise, an invalid parameter error is returned.
 * @property authorId Return issues created by the given user id. Combine with scope=all or scope=assigned*to*me.
 * @property confidential Filter confidential or public issues.
 * @property createdAfter Return issues created on or after the given time. Expected in ISO 8601 format (2019-03-15T08:00:00Z)
 * @property createdBefore Return issues created on or before the given time. Expected in ISO 8601 format (2019-03-15T08:00:00Z)
 * @property dueDate Return issues that have no due date, are overdue, or whose due date is this week, this month, or between two weeks ago and next month. Accepts: 0 (no due date), any, today, tomorrow, overdue, week, month, next*month*and*previous*two_weeks.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property iids Return only the issues having the given iid
 * @property issueType Filter to a given type of issue. Valid values are [issue incident test_case]. (Introduced in GitLab 13.12)
 * @property issues The list of issues returned by the search.
 * @property labels Return issues with labels. Issues must have all labels to be returned. None lists all issues with no labels. Any lists all issues with at least one label. No+Label (Deprecated) lists all issues with no labels. Predefined names are case-insensitive.
 * @property milestone The milestone title. None lists all issues with no milestone. Any lists all issues that have an assigned milestone.
 * @property myReactionEmoji Return issues reacted by the authenticated user by the given emoji. None returns issues not given a reaction. Any returns issues given at least one reaction.
 * @property notAssigneeIds Return issues that do not match the assignee id.
 * @property notAuthorIds Return issues that do not match the author id.
 * @property notLabels Return issues that do not match the labels.
 * @property notMilestone Return issues that do not match the milestone.
 * @property notMyReactionEmojis Return issues not reacted by the authenticated user by the given emoji.
 * @property orderBy Return issues ordered by. Valid values are `created_at`, `updated_at`, `priority`, `due_date`, `relative_position`, `label_priority`, `milestone_due`, `popularity`, `weight`. Default is created_at
 * @property project The name or id of the project.
 * @property scope Return issues for the given scope. Valid values are `created_by_me`, `assigned_to_me`, `all`. Defaults to all.
 * @property search Search project issues against their title and description
 * @property sort Return issues sorted in asc or desc order. Default is desc
 * @property updatedAfter Return issues updated on or after the given time. Expected in ISO 8601 format (2019-03-15T08:00:00Z)
 * @property updatedBefore Return issues updated on or before the given time. Expected in ISO 8601 format (2019-03-15T08:00:00Z)
 * @property weight Return issues with the specified weight. None returns issues with no weight assigned. Any returns issues with a weight assigned.
 * @property withLabelsDetails If true, the response returns more details for each label in labels field: :name, :color, :description, :description*html, :text*color. Default is false. description_html was introduced in GitLab 12.7
 */
public data class GetProjectIssuesResult(
    public val assigneeId: Int? = null,
    public val assigneeUsername: String? = null,
    public val authorId: Int? = null,
    public val confidential: Boolean? = null,
    public val createdAfter: String? = null,
    public val createdBefore: String? = null,
    public val dueDate: String? = null,
    public val id: String,
    public val iids: List<Int>? = null,
    public val issueType: String? = null,
    public val issues: List<GetProjectIssuesIssue>,
    public val labels: List<String>? = null,
    public val milestone: String? = null,
    public val myReactionEmoji: String? = null,
    public val notAssigneeIds: List<Int>? = null,
    public val notAuthorIds: List<Int>? = null,
    public val notLabels: List<String>? = null,
    public val notMilestone: String? = null,
    public val notMyReactionEmojis: List<String>? = null,
    public val orderBy: String? = null,
    public val project: String,
    public val scope: String? = null,
    public val search: String? = null,
    public val sort: String? = null,
    public val updatedAfter: String? = null,
    public val updatedBefore: String? = null,
    public val weight: Int? = null,
    public val withLabelsDetails: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectIssuesResult): GetProjectIssuesResult = GetProjectIssuesResult(
            assigneeId = javaType.assigneeId().map({ args0 -> args0 }).orElse(null),
            assigneeUsername = javaType.assigneeUsername().map({ args0 -> args0 }).orElse(null),
            authorId = javaType.authorId().map({ args0 -> args0 }).orElse(null),
            confidential = javaType.confidential().map({ args0 -> args0 }).orElse(null),
            createdAfter = javaType.createdAfter().map({ args0 -> args0 }).orElse(null),
            createdBefore = javaType.createdBefore().map({ args0 -> args0 }).orElse(null),
            dueDate = javaType.dueDate().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            iids = javaType.iids().map({ args0 -> args0 }),
            issueType = javaType.issueType().map({ args0 -> args0 }).orElse(null),
            issues = javaType.issues().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectIssuesIssue.Companion.toKotlin(args0)
                })
            }),
            labels = javaType.labels().map({ args0 -> args0 }),
            milestone = javaType.milestone().map({ args0 -> args0 }).orElse(null),
            myReactionEmoji = javaType.myReactionEmoji().map({ args0 -> args0 }).orElse(null),
            notAssigneeIds = javaType.notAssigneeIds().map({ args0 -> args0 }),
            notAuthorIds = javaType.notAuthorIds().map({ args0 -> args0 }),
            notLabels = javaType.notLabels().map({ args0 -> args0 }),
            notMilestone = javaType.notMilestone().map({ args0 -> args0 }).orElse(null),
            notMyReactionEmojis = javaType.notMyReactionEmojis().map({ args0 -> args0 }),
            orderBy = javaType.orderBy().map({ args0 -> args0 }).orElse(null),
            project = javaType.project(),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            search = javaType.search().map({ args0 -> args0 }).orElse(null),
            sort = javaType.sort().map({ args0 -> args0 }).orElse(null),
            updatedAfter = javaType.updatedAfter().map({ args0 -> args0 }).orElse(null),
            updatedBefore = javaType.updatedBefore().map({ args0 -> args0 }).orElse(null),
            weight = javaType.weight().map({ args0 -> args0 }).orElse(null),
            withLabelsDetails = javaType.withLabelsDetails().map({ args0 -> args0 }).orElse(null),
        )
    }
}
