@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProjectMembership.
 * @property fullPath The full path of the project.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property inherited Return all project members including members through ancestor groups
 * @property members The list of project members.
 * @property projectId The ID of the project.
 * @property query A query string to search for members
 */
public data class GetProjectMembershipResult(
    public val fullPath: String,
    public val id: String,
    public val inherited: Boolean? = null,
    public val members: List<GetProjectMembershipMember>,
    public val projectId: Int,
    public val query: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectMembershipResult): GetProjectMembershipResult = GetProjectMembershipResult(
            fullPath = javaType.fullPath(),
            id = javaType.id(),
            inherited = javaType.inherited().map({ args0 -> args0 }).orElse(null),
            members = javaType.members().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectMembershipMember.Companion.toKotlin(args0)
                })
            }),
            projectId = javaType.projectId(),
            query = javaType.query().map({ args0 -> args0 }).orElse(null),
        )
    }
}
