@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createdAt The time of creation of the milestone. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
 * @property description The description of the milestone.
 * @property dueDate The due date of the milestone. Date time string in the format YYYY-MM-DD, for example 2016-03-11.
 * @property expired Bool, true if milestone expired.
 * @property iid The ID of the project's milestone.
 * @property milestoneId The instance-wide ID of the project’s milestone.
 * @property project The ID or URL-encoded path of the project owned by the authenticated user.
 * @property projectId The project ID of milestone.
 * @property startDate The start date of the milestone. Date time string in the format YYYY-MM-DD, for example 2016-03-11.
 * @property state The state of the milestone. Valid values are: `active`, `closed`.
 * @property title The title of a milestone.
 * @property updatedAt The last update time of the milestone. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
 * @property webUrl The web URL of the milestone.
 */
public data class GetProjectMilestonesMilestone(
    public val createdAt: String,
    public val description: String,
    public val dueDate: String,
    public val expired: Boolean,
    public val iid: Int,
    public val milestoneId: Int,
    public val project: String,
    public val projectId: Int,
    public val startDate: String,
    public val state: String,
    public val title: String,
    public val updatedAt: String,
    public val webUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectMilestonesMilestone): GetProjectMilestonesMilestone = GetProjectMilestonesMilestone(
            createdAt = javaType.createdAt(),
            description = javaType.description(),
            dueDate = javaType.dueDate(),
            expired = javaType.expired(),
            iid = javaType.iid(),
            milestoneId = javaType.milestoneId(),
            project = javaType.project(),
            projectId = javaType.projectId(),
            startDate = javaType.startDate(),
            state = javaType.state(),
            title = javaType.title(),
            updatedAt = javaType.updatedAt(),
            webUrl = javaType.webUrl(),
        )
    }
}
