@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProjectMilestones.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property iids Return only the milestones having the given `iid` (Note: ignored if `include_parent_milestones` is set as `true`).
 * @property includeParentMilestones Include group milestones from parent group and its ancestors. Introduced in GitLab 13.4.
 * @property milestones List of milestones from a project.
 * @property project The ID or URL-encoded path of the project owned by the authenticated user.
 * @property search Return only milestones with a title or description matching the provided string.
 * @property state Return only `active` or `closed` milestones.
 * @property title Return only the milestones having the given `title`.
 */
public data class GetProjectMilestonesResult(
    public val id: String,
    public val iids: List<Int>? = null,
    public val includeParentMilestones: Boolean? = null,
    public val milestones: List<GetProjectMilestonesMilestone>,
    public val project: String,
    public val search: String? = null,
    public val state: String? = null,
    public val title: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectMilestonesResult): GetProjectMilestonesResult = GetProjectMilestonesResult(
            id = javaType.id(),
            iids = javaType.iids().map({ args0 -> args0 }),
            includeParentMilestones = javaType.includeParentMilestones().map({ args0 -> args0 }).orElse(null),
            milestones = javaType.milestones().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectMilestonesMilestone.Companion.toKotlin(args0)
                })
            }),
            project = javaType.project(),
            search = javaType.search().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            title = javaType.title().map({ args0 -> args0 }).orElse(null),
        )
    }
}
