@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProjectProtectedBranch.
 * @property allowForcePush Whether force push is allowed.
 * @property codeOwnerApprovalRequired Reject code pushes that change files listed in the CODEOWNERS file.
 * @property id The ID of this resource.
 * @property mergeAccessLevels Array of access levels and user(s)/group(s) allowed to merge to protected branch.
 * @property name The name of the protected branch.
 * @property projectId The integer or path with namespace that uniquely identifies the project.
 * @property pushAccessLevels Array of access levels and user(s)/group(s) allowed to push to protected branch.
 */
public data class GetProjectProtectedBranchResult(
    public val allowForcePush: Boolean,
    public val codeOwnerApprovalRequired: Boolean,
    public val id: Int,
    public val mergeAccessLevels: List<GetProjectProtectedBranchMergeAccessLevel>? = null,
    public val name: String,
    public val projectId: String,
    public val pushAccessLevels: List<GetProjectProtectedBranchPushAccessLevel>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.gitlab.outputs.GetProjectProtectedBranchResult): GetProjectProtectedBranchResult = GetProjectProtectedBranchResult(
            allowForcePush = javaType.allowForcePush(),
            codeOwnerApprovalRequired = javaType.codeOwnerApprovalRequired(),
            id = javaType.id(),
            mergeAccessLevels = javaType.mergeAccessLevels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectProtectedBranchMergeAccessLevel.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            projectId = javaType.projectId(),
            pushAccessLevels = javaType.pushAccessLevels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.gitlab.kotlin.outputs.GetProjectProtectedBranchPushAccessLevel.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
